(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10312,        404]*)
(*NotebookOutlinePosition[     11215,        434]*)
(*  CellTagsIndexPosition[     11171,        430]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Find a Second Solution"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Given one solution of a homogeneous second order differential equation, find \
a second linearly independent solution."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Second Solution (Theory)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["The generic code."], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Here is the differential operator."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[L, x, y, a1, a2, y1, y2]\), "\n", 
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{\(a[2]\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{\(a[1]\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(a[0]\ y[x]\)}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(a[0]\ y[x]\), "+", 
      RowBox[{\(a[1]\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{\(a[2]\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Closed]],

Cell[TextData[
"This function finds a second solution, given that y1[x], is a known first \
solution. This is a delayed definition, so nothing happens until the function \
is invoked, as it is in the examples that follow."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{
    \(Clear[SecondSolution]\), "\n", 
    \(SecondSolution[x_, y1_, a1_, a2_] := 
      y1[x]\ \(\[Integral]\(Exp[\(-\(\[Integral]\(a1[x]\/a2[
                              x]\) \[DifferentialD]x\)\)]\/y1[x]\^2\) \
\[DifferentialD]x\)\)}], "Input",
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Examples"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Example 1"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[L, x, y, y1, y2]\), "\n", 
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[DoublePrime]",
            MultilineFunction->None], "[", "x", "]"}], "+", 
        RowBox[{"4", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(4\ y[x]\)}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(4\ y[x]\), "+", 
      RowBox[{"4", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["y", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1[x_] = Exp[\(-2\)\ x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(\(-2\)\ x\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, y1]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[TextData["Here a[2]==1, a[1]==4, a[0]==4, so:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(a[2]\)[x_] = 1\), "\n", 
    \(\(a[1]\)[x_] = 4\), "\n", 
    \(y2[x_] = SecondSolution[x, y1, a[1], a[2]]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(1\)], "Output"],

Cell[BoxData[
    \(4\)], "Output"],

Cell[BoxData[
    \(\[ExponentialE]\^\(\(-2\)\ x\)\ x\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[x, y2]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example 2"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[L, x, y, y1, y2]\), "\n", 
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{\((1 - 2\ x - x\^2)\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"2", " ", \((1 + x)\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "-", \(2\ y[x]\)}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(\(-2\)\ y[x]\), "+", 
      RowBox[{"2", " ", \((1 + x)\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{\((1 - 2\ x - x\^2)\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1[x_] = x + 1\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(1 + x\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, y1]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[TextData["Here a[2]==1, a[1]==4, a[0]==4, so:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(a[2]\)[x_] = 1 - 2\ x - x\^2\), "\n", 
    \(\(a[1]\)[x_] = 2\ \((1 + x)\)\), "\n", 
    \(y2[x_] = SecondSolution[x, y1, a[1], a[2]] // Simplify\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(1 - 2\ x - x\^2\)], "Output"],

Cell[BoxData[
    \(2\ \((1 + x)\)\)], "Output"],

Cell[BoxData[
    \(2 + x + x\^2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[x, y2]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example 3"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[L, x, y, y1, y2]\), "\n", 
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{\(x\^2\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"x", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(\((x\^2 - 1\/4)\)\ y[x]\)}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(\((\(-\(1\/4\)\) + x\^2)\)\ y[x]\), "+", 
      RowBox[{"x", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{\(x\^2\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1[x_] = Sin[x]\/\@x\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(Sin[x]\/\@x\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, y1]\)], "Input"],

Cell[BoxData[
    \(\(\((\(-\(1\/4\)\) + x\^2)\)\ Sin[x]\)\/\@x + 
      x\ \((Cos[x]\/\@x - Sin[x]\/\(2\ x\^\(3/2\)\))\) + 
      x\^2\ \((\(-\(Cos[
                    x]\/x\^\(3/2\)\)\) + \(3\ Sin[x]\)\/\(4\ x\^\(5/2\)\) - 
            Sin[x]\/\@x)\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, y1] // Simplify\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[TextData["Here a[2]==1, a[1]==4, a[0]==4, so:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(a[2]\)[x_] = x\^2\), "\n", 
    \(\(a[1]\)[x_] = x\), "\n", 
    \(y2[x_] = SecondSolution[x, y1, a[1], a[2]]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(x\^2\)], "Output"],

Cell[BoxData[
    \(x\)], "Output"],

Cell[BoxData[
    \(\(-\(Cos[x]\/\@x\)\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[x, y2]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 365},
WindowMargins->{{69, Automatic}, {Automatic, 33}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 101, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1880, 57, 194, 4, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2099, 65, 102, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2226, 71, 98, 2, 46, "Subsection",
  Evaluatable->False],
Cell[2327, 75, 109, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2461, 81, 496, 12, 43, "Input"],
Cell[2960, 95, 366, 9, 27, "Output"]
}, Closed]],
Cell[3341, 107, 281, 5, 68, "Text",
  Evaluatable->False],
Cell[3625, 114, 290, 6, 101, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3964, 126, 86, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4075, 132, 90, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4190, 138, 440, 11, 43, "Input"],
Cell[4633, 151, 320, 8, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4990, 164, 83, 2, 27, "Input"],
Cell[5076, 168, 64, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5177, 174, 68, 2, 27, "Input"],
Cell[5248, 178, 35, 1, 27, "Output"]
}, Closed]],
Cell[5298, 182, 110, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5433, 188, 170, 4, 59, "Input"],
Cell[5606, 194, 35, 1, 27, "Output"],
Cell[5644, 197, 35, 1, 27, "Output"],
Cell[5682, 200, 67, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5786, 206, 78, 2, 27, "Input"],
Cell[5867, 210, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5951, 217, 90, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6066, 223, 511, 12, 47, "Input"],
Cell[6580, 237, 394, 9, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7011, 251, 74, 2, 27, "Input"],
Cell[7088, 255, 39, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7164, 261, 68, 2, 27, "Input"],
Cell[7235, 265, 35, 1, 27, "Output"]
}, Closed]],
Cell[7285, 269, 110, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7420, 275, 209, 4, 77, "Input"],
Cell[7632, 281, 49, 1, 29, "Output"],
Cell[7684, 284, 48, 1, 27, "Output"],
Cell[7735, 287, 46, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7818, 293, 78, 2, 27, "Input"],
Cell[7899, 297, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7983, 304, 90, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8098, 310, 496, 12, 60, "Input"],
Cell[8597, 324, 383, 9, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[9017, 338, 80, 2, 47, "Input"],
Cell[9100, 342, 45, 1, 46, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[9182, 348, 41, 1, 27, "Input"],
Cell[9226, 351, 267, 5, 97, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[9530, 361, 80, 2, 27, "Input"],
Cell[9613, 365, 35, 1, 27, "Output"]
}, Closed]],
Cell[9663, 369, 110, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9798, 375, 173, 4, 61, "Input"],
Cell[9974, 381, 38, 1, 29, "Output"],
Cell[10015, 384, 35, 1, 27, "Output"],
Cell[10053, 387, 54, 1, 46, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10144, 393, 78, 2, 27, "Input"],
Cell[10225, 397, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

l[10309, 339, 161, 4, 70, "Input"],
Cell[10473, 345, 87, 3, 70, "Output"],
Cell[10563, 350, 84, 3, 70, "Output"],
Cell[10650, 355, 103, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10785, 360, 78, 2, 70, "Input"],
Cell[10866, 364, 84, 3, 70, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
